// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanUrlClassifierMetrics_h
#define mozilla_GleanUrlClassifierMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace urlclassifier {
  /**
   * generated from urlclassifier.async_classifylocal_time
   * Time spent per AsyncClassifyLocalWithTables (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram URLCLASSIFIER_ASYNC_CLASSIFYLOCAL_TIME.
   */
  constexpr impl::TimingDistributionMetric async_classifylocal_time(5650);

  /**
   * generated from urlclassifier.cl_check_time
   * Time spent per classifier lookup (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram URLCLASSIFIER_CL_CHECK_TIME.
   */
  constexpr impl::TimingDistributionMetric cl_check_time(5651);

  /**
   * generated from urlclassifier.cl_keyed_update_time
   * Time spent per classifier update (ms), keyed by the name of the provider.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram URLCLASSIFIER_CL_KEYED_UPDATE_TIME.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> cl_keyed_update_time(5652);

  /**
   * generated from urlclassifier.complete_remote_status2
   * Server HTTP status code from remote SafeBrowsing gethash lookups. (0=1xx, 1=200, 2=2xx, 3=204, 4=3xx, 5=400, 6=4xx, 7=403, 8=404, 9=408, 10=413, 11=5xx, 12=502|504|511, 13=503, 14=505, 15=Other). Keyed by provider
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram URLCLASSIFIER_COMPLETE_REMOTE_STATUS2.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> complete_remote_status2(5653);

  /**
   * generated from urlclassifier.complete_server_response_time
   * Server response time to getHash request (ms). Keyed by provider
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram URLCLASSIFIER_COMPLETE_SERVER_RESPONSE_TIME.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> complete_server_response_time(5654);

  /**
   * generated from urlclassifier.completion_error
   * SafeBrowsing v4 hash completion error (0 = success, 1 = parsing failure, 2 = unknown threat type)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram URLCLASSIFIER_COMPLETION_ERROR.
   */
  constexpr impl::CustomDistributionMetric completion_error(5655);

  /**
   * generated from urlclassifier.lookup_time_2
   * Time spent per dbservice lookup (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram URLCLASSIFIER_LOOKUP_TIME_2.
   */
  constexpr impl::TimingDistributionMetric lookup_time_2(5656);

  /**
   * generated from urlclassifier.shutdown_time
   * Time spent per dbservice shutdown (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram URLCLASSIFIER_SHUTDOWN_TIME.
   */
  constexpr impl::TimingDistributionMetric shutdown_time(5657);

  /**
   * generated from urlclassifier.threathit_network_error
   * Whether or not an error was encountered while sending a Safe Browsing ThreatHit report. (0=sucess, 1=unknown error, 2=already connected, 3=not connected, 4=connection refused,5=net timeout, 6=offline, 7=port access not allowed, 8=net reset, 9=net interrupt, 10=proxy connection refused, 11=partial transfer, 12=inadequate security, 13=unknown host, 14=dns lookup queue full, 15=unknown proxy host)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram URLCLASSIFIER_THREATHIT_NETWORK_ERROR.
   */
  constexpr impl::CustomDistributionMetric threathit_network_error(5658);

  /**
   * generated from urlclassifier.threathit_remote_status
   * Server HTTP status code from Safe Browsing ThreatHit report. (0=1xx, 1=200, 2=2xx, 3=204, 4=3xx, 5=400, 6=4xx, 7=403, 8=404, 9=408, 10=413, 11=5xx, 12=502|504|511, 13=503, 14=505, 15=Other)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram URLCLASSIFIER_THREATHIT_REMOTE_STATUS.
   */
  constexpr impl::CustomDistributionMetric threathit_remote_status(5659);

  /**
   * generated from urlclassifier.ui_events
   * URL CLassifier-related (aka Safe Browsing) UI events. See nsIUrlClassifierUITelemetry.idl for the specific values.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram URLCLASSIFIER_UI_EVENTS.
   */
  constexpr impl::CustomDistributionMetric ui_events(5660);

  /**
   * generated from urlclassifier.update_error
   * Whether or not an error was encountered while processing a Safe Browsing update (0 = success, 1 = unspecified error, 2 = addition of an already existing prefix, 3 = parser got into an infinite loop, 4 = removal index out of bounds, 5 = checksum mismatch, 6 = missing checksum, 7 = update while shutdown, 8 = cannot find table, 9 = build prefix failure, 10 = write disk failure, 11 = protocol parser error). Keyed by provider
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram URLCLASSIFIER_UPDATE_ERROR.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> update_error(5661);

  /**
   * generated from urlclassifier.update_remote_network_error
   * Network error from SafeBrowsing database updates. (0=sucess, 1=unknown error, 2=already connected, 3=not connected, 4=connection refused,5=net timeout, 6=offline, 7=port access not allowed, 8=net reset, 9=net interrupt, 10=proxy connection refused,11=partial transfer,12=inadequate security,13=unknown host,14=dns lookup queue full,15=unknown proxy host
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram URLCLASSIFIER_UPDATE_REMOTE_NETWORK_ERROR.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> update_remote_network_error(5662);

  /**
   * generated from urlclassifier.update_remote_status2
   * Server HTTP status code from SafeBrowsing database updates. (0=1xx, 1=200, 2=2xx, 3=204, 4=3xx, 5=400, 6=4xx, 7=403, 8=404, 9=408, 10=413, 11=5xx, 12=502|504|511, 13=503, 14=505, 15=Other). Keyed by provider
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram URLCLASSIFIER_UPDATE_REMOTE_STATUS2.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> update_remote_status2(5663);

  /**
   * generated from urlclassifier.update_server_response_time
   * Server response time to update request (ms). Keyed by provider
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram URLCLASSIFIER_UPDATE_SERVER_RESPONSE_TIME.
   */
  constexpr impl::Labeled<impl::TimingDistributionMetric, DynamicLabel> update_server_response_time(5664);

  /**
   * generated from urlclassifier.update_timeout
   * Whether or not an update timed out (0 = no timeout, 1 = server respond
   * timeout, 2 = overall timeout). Keyed by provider This metric was generated to correspond to the Legacy Telemetry enumerated histogram URLCLASSIFIER_UPDATE_TIMEOUT.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, DynamicLabel> update_timeout(5665);

  /**
   * generated from urlclassifier.vlps_construct_time
   * Time spent constructing Variable-Length PrefixSet from file (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram URLCLASSIFIER_VLPS_CONSTRUCT_TIME.
   */
  constexpr impl::TimingDistributionMetric vlps_construct_time(5666);

  /**
   * generated from urlclassifier.vlps_fallocate_time
   * Time spent fallocating Variable-Length PrefixSet (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram URLCLASSIFIER_VLPS_FALLOCATE_TIME.
   */
  constexpr impl::TimingDistributionMetric vlps_fallocate_time(5667);

  /**
   * generated from urlclassifier.vlps_fileload_time
   * Time spent loading Variable-Length PrefixSet from file (ms)
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram URLCLASSIFIER_VLPS_FILELOAD_TIME.
   */
  constexpr impl::TimingDistributionMetric vlps_fileload_time(5668);

  /**
   * generated from urlclassifier.vlps_metadata_corrupt
   */
  enum class VlpsMetadataCorruptLabel: uint16_t {
    eFalse = 0,
    eTrue = 1,
    e__Other__,
  };
  /**
   * Whether or not the metadata for a variable-length prefix set loaded from disk is corrupted (true = file corrupted).
   * This metric was generated to correspond to the Legacy Telemetry boolean histogram URLCLASSIFIER_VLPS_METADATA_CORRUPT.
   */
  constexpr impl::Labeled<impl::CounterMetric, VlpsMetadataCorruptLabel> vlps_metadata_corrupt(5669);
}

} // namespace mozilla::glean

#endif // mozilla_GleanUrlClassifierMetrics_h
