/* THIS FILE IS AUTOGENERATED FROM Navigator.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_NavigatorBinding_h
#define mozilla_dom_NavigatorBinding_h

#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/CallbackFunction.h"
#include "mozilla/dom/File.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/ToJSValue.h"

namespace mozilla {

class DOMMediaStream;

namespace dom {

class File;
class MediaStreamError;
struct NativePropertyHooks;
class Navigator;
class NavigatorUserMediaErrorCallback;
class NavigatorUserMediaSuccessCallback;
class ProtoAndIfaceCache;
struct ShareDataAtoms;

} // namespace dom

} // namespace mozilla

namespace mozilla::dom {

enum class AutoplayPolicy : uint8_t {
  Allowed,
  Allowed_muted,
  Disallowed,
  EndGuard_
};

namespace AutoplayPolicyValues {
extern const EnumEntry strings[4];

static constexpr size_t Count = 3;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(AutoplayPolicy::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(AutoplayPolicy stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace AutoplayPolicyValues

bool
ToJSValue(JSContext* aCx, AutoplayPolicy aArgument, JS::MutableHandle<JS::Value> aValue);


enum class AutoplayPolicyMediaType : uint8_t {
  Mediaelement,
  Audiocontext,
  EndGuard_
};

namespace AutoplayPolicyMediaTypeValues {
extern const EnumEntry strings[3];

static constexpr size_t Count = 2;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(AutoplayPolicyMediaType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(AutoplayPolicyMediaType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace AutoplayPolicyMediaTypeValues

bool
ToJSValue(JSContext* aCx, AutoplayPolicyMediaType aArgument, JS::MutableHandle<JS::Value> aValue);


class NavigatorUserMediaErrorCallback : public CallbackFunction
{
public:
  explicit inline NavigatorUserMediaErrorCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline NavigatorUserMediaErrorCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline NavigatorUserMediaErrorCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline NavigatorUserMediaErrorCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, MediaStreamError& error, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "NavigatorUserMediaErrorCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, error, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(MediaStreamError& error, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "NavigatorUserMediaErrorCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, error, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, MediaStreamError& error, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, error, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(MediaStreamError& error, const char* aExecutionReason = nullptr)
  {
    return Call(error, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const NavigatorUserMediaErrorCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, MediaStreamError& error, ErrorResult& aRv);
};


namespace binding_detail {
class FastNavigatorUserMediaErrorCallback : public NavigatorUserMediaErrorCallback
{
public:
  explicit inline FastNavigatorUserMediaErrorCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : NavigatorUserMediaErrorCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    NavigatorUserMediaErrorCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    NavigatorUserMediaErrorCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


class NavigatorUserMediaSuccessCallback : public CallbackFunction
{
public:
  explicit inline NavigatorUserMediaSuccessCallback(JSContext* aCx, JS::Handle<JSObject*> aCallback, JS::Handle<JSObject*> aCallbackGlobal, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCx, aCallback, aCallbackGlobal, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline NavigatorUserMediaSuccessCallback(JSObject* aCallback, JSObject* aCallbackGlobal, const FastCallbackConstructor& )
    : CallbackFunction(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline NavigatorUserMediaSuccessCallback(JSObject* aCallback, JSObject* aCallbackGlobal, JSObject* aAsyncStack, nsIGlobalObject* aIncumbentGlobal)
    : CallbackFunction(aCallback, aCallbackGlobal, aAsyncStack, aIncumbentGlobal)
  {
    MOZ_ASSERT(JS::IsCallable(mCallback));
  }

  explicit inline NavigatorUserMediaSuccessCallback(CallbackFunction* aOther)
    : CallbackFunction(aOther)
  {
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, DOMMediaStream& stream, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "NavigatorUserMediaSuccessCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    JS::Rooted<JS::Value> thisValJS(s.GetContext());
    if (!ToJSValue(s.GetContext(), thisVal, &thisValJS)) {
      aRv.Throw(NS_ERROR_FAILURE);
      return;
    }
    return Call(s.GetCallContext(), thisValJS, stream, aRv);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(DOMMediaStream& stream, ErrorResult& aRv, const char* aExecutionReason = nullptr, ExceptionHandling aExceptionHandling = eReportExceptions, JS::Realm* aRealm = nullptr)
  {
    MOZ_ASSERT(!aRv.Failed(), "Don't pass an already-failed ErrorResult to a callback!");
    if (!aExecutionReason) {
      aExecutionReason = "NavigatorUserMediaSuccessCallback";
    }
    CallSetup s(this, aRv, aExecutionReason, aExceptionHandling, aRealm);
    if (!s.GetContext()) {
      MOZ_ASSERT(aRv.Failed());
      return;
    }
    return Call(s.GetCallContext(), JS::UndefinedHandleValue, stream, aRv);
  }

  template <typename T>
  MOZ_CAN_RUN_SCRIPT inline void
  Call(const T& thisVal, DOMMediaStream& stream, const char* aExecutionReason = nullptr)
  {
    return Call(thisVal, stream, IgnoreErrors(), aExecutionReason);
  }

  MOZ_CAN_RUN_SCRIPT inline void
  Call(DOMMediaStream& stream, const char* aExecutionReason = nullptr)
  {
    return Call(stream, IgnoreErrors(), aExecutionReason, eReportExceptions, nullptr);
  }

  inline bool
  operator==(const NavigatorUserMediaSuccessCallback& aOther) const
  {
    return CallbackFunction::operator==(aOther);
  }

private:
  MOZ_CAN_RUN_SCRIPT void Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, DOMMediaStream& stream, ErrorResult& aRv);
};


namespace binding_detail {
class FastNavigatorUserMediaSuccessCallback : public NavigatorUserMediaSuccessCallback
{
public:
  explicit inline FastNavigatorUserMediaSuccessCallback(JSObject* aCallback, JSObject* aCallbackGlobal)
    : NavigatorUserMediaSuccessCallback(aCallback, aCallbackGlobal, FastCallbackConstructor())
  {
  }

  inline void
  Trace(JSTracer* aTracer)
  {
    NavigatorUserMediaSuccessCallback::Trace(aTracer);
  }

  inline void
  FinishSlowJSInitIfMoreThanOneOwner(JSContext* aCx)
  {
    NavigatorUserMediaSuccessCallback::FinishSlowJSInitIfMoreThanOneOwner(aCx);
  }
};
} // namespace binding_detail


struct ShareData : public DictionaryBase
{
  MOZ_INIT_OUTSIDE_CTOR Optional<Sequence<OwningNonNull<mozilla::dom::File>>> mFiles;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mText;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mTitle;
  MOZ_INIT_OUTSIDE_CTOR Optional<nsString> mUrl;

  ShareData();

  explicit inline ShareData(const FastDictionaryInitializer& )
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  ShareData(ShareData&& aOther) = default;

  explicit inline ShareData(const ShareData& aOther)
  {
    *this = aOther;
  }

  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);

  inline void
  TraverseForCC(nsCycleCollectionTraversalCallback& aCallback, uint32_t aFlags)
  {
    ImplCycleCollectionTraverse(aCallback, mFiles, "mFiles", aFlags);
  }

  inline void
  UnlinkForCC()
  {
    ImplCycleCollectionUnlink(mFiles);
  }

  ShareData&
  operator=(const ShareData& aOther);

private:
  static bool
  InitIds(JSContext* cx, ShareDataAtoms* atomsCache);
};

namespace binding_detail {
struct FastShareData : public ShareData
{
  inline FastShareData()
    : ShareData(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace Navigator_Binding {

  typedef mozilla::dom::Navigator NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::Navigator* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  ClearCachedActiveVRDisplaysValue(mozilla::dom::Navigator* aObject);

  void
  ClearCachedPlatformValue(mozilla::dom::Navigator* aObject);

  void
  ClearCachedUserAgentValue(mozilla::dom::Navigator* aObject);

  void
  ClearCachedLanguageValue(mozilla::dom::Navigator* aObject);

  void
  ClearCachedLanguagesValue(mozilla::dom::Navigator* aObject);

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::Navigator,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::Navigator,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::Navigator,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace Navigator_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_NavigatorBinding_h
